import { BookOpen, Mail, Phone, MapPin, Clock, Facebook, Instagram, MessageCircle } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-split">
      <div className="container">
        <div className="footer-content-split">
          <div className="footer-section-split">
            <div className="footer-logo-split">
              <div className="footer-logo-icon-wrapper">
                <BookOpen className="footer-logo-icon" size={24} />
              </div>
              <h2 className="footer-logo-text-split">Академия</h2>
            </div>
            <p className="footer-description-split">
              Современная платформа для онлайн-обучения. 
              Качественные курсы с практическими заданиями и поддержкой преподавателей.
            </p>
            <div className="footer-social-split">
              <a href="#" className="social-link-split">
                <Instagram size={20} />
              </a>
              <a href="#" className="social-link-split">
                <Facebook size={20} />
              </a>
              <a href="#" className="social-link-split">
                <MessageCircle size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-split">
            <h3 className="footer-title-split">Навигация</h3>
            <ul className="footer-links-split">
              <li><a href="/">Мои заявки</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-split">
            <h3 className="footer-title-split">Контакты</h3>
            <ul className="footer-links-split">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@academy.ru">info@academy.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Образовательная, 15</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Пт: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-split">
          <p>&copy; 2025 Академия. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer
